##############################################################################
#
#    OpenEduCat Inc
#    Copyright (C) 2009-TODAY OpenEduCat Inc(<https://www.openeducat.org>).
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU Lesser General Public License as
#    published by the Free Software Foundation, either version 3 of the
#    License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
##############################################################################
from odoo import _, api, fields, models
from odoo.exceptions import ValidationError


class OpGradeConfiguration(models.Model):
    _name = "op.grade.configuration"
    _rec_name = "result"
    _description = "Grade Configuration"

    min_per = fields.Integer('Minimum Percentage', required=True)
    max_per = fields.Integer('Maximum Percentage', required=True)
    result = fields.Char('Result to Display', required=True)

    @api.constrains("max_per")
    def max_per_validation(self):
        if self.max_per > 100:
            raise ValidationError(_(
                "Maximum percentage should not be greater than 100"))
        if self.max_per < self.min_per:
            raise ValidationError(_(
                "Minimum percentage should be not greater than Maximum percentage"))
